/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.component.wire;

import com.technicalitiesmc.lib.circuit.component.CircuitComponent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentSlot;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import com.technicalitiesmc.scm.component.InterfaceLookup;
import com.technicalitiesmc.scm.component.wire.WireComponentBase;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public abstract class VerticalWireComponentBase<T extends VerticalWireComponentBase<T>>
extends WireComponentBase<T> {
    protected VerticalWireComponentBase(RegistryObject<ComponentType> type, ComponentContext context, InterfaceLookup<T> interfaceLookup) {
        super(type, context, interfaceLookup);
    }

    @Override
    protected VecDirectionFlags getConnectableSides() {
        return VecDirectionFlags.verticals();
    }

    @Override
    @Nullable
    protected CircuitComponent findConnectionTarget(VecDirection side) {
        CircuitComponent neighbor = this.getSibling(side.isPositive() ? ComponentSlot.SUPPORT : ComponentSlot.DEFAULT);
        if (neighbor != null) {
            return neighbor;
        }
        neighbor = this.getComponentAt(side.getOffset(), side.isPositive() ? ComponentSlot.DEFAULT : ComponentSlot.SUPPORT);
        if (neighbor != null) {
            return neighbor;
        }
        return this.getComponentAt(side.getOffset(), ComponentSlot.OVERLAY);
    }
}

